<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function productCategory()
    {
        return $this->belongsTo('ProductCategory');
    }

    public function orderItems()
    {
        return $this->hasMany('App\Models\OrderItem');
    }

    public function vatCategory()
    {
        return $this->belongsTo('App\Models\VatCategory');
    }

}